<?php
defined('PF_VERSION') OR exit('Access denied');
class Pf_menu_wg {

    protected $db;
    protected $all;
    protected $pageurl;
            function __construct() {
        $this->db   =   Pf::database();
        $this->db->select('id,page_url','pf_pages');
        $this->pageurl    =   $this->db->fetch_assoc_all();
    }
    private function pick_menu($id){
        $all    =   get_option('menu');
        $data   =   '';
        foreach($all as $k=>$v){
            if($v['id']==$id){
                $data   =   $all[$k]['data'];
            }
        }
        return $data;
    }
    public function filter_menu($list,$data) {
        foreach($list as $k=>$v){
            if($this->check_child($list[$k])==true){
                $list[$k]['children']=$this->filter_menu($list[$k]['children'], $data);
            }
            foreach ($data as $item){
                if($item['id']==$v['id'] && isset($item['status']) && $item['status']!=1){
                    unset($list[$k]);
                }
            }
        }
        return $list;
    }
    private function check_child($array) {
        if(!empty($array['children']) && is_array($array['children']))
            return true;
        else
            return false;
    }
    private function choose_item($array, $id) {
        for($i=0; $i<count($array);$i++){
            if($array[$i]['id']==$id)
                return $i;
        }
    }
    private function get_page_link($pageid) {
        $url    =   $this->pageurl;
        foreach($url as $item){
            $list[$item['id']]= $item['page_url'];
        }
        if(count($url)>0 && !empty($list[$pageid]))
        return public_url($list[$pageid],false);
        else
            return '';
    }
    private function url_builder($type, $call) {
        switch ($type) {
            case 'url':
                $link   =   $call;
                break;
            case 'page':
                $link   =   $this->get_page_link($call);
                break;
            default :
                $link   =   $call;
        }
        return $link;
    }
    private function builder_v($data,$detail) {
        if (!empty($data)) {
            foreach ($data as $item) {
                $key = $this->choose_item($detail, $item['id']);
                $itemlink = $this->url_builder($detail[$key]['type'], $detail[$key]['call']);
                if ($this->check_child($item))
                    $li_class = "class='dropdown-submenu'";
                else
                    $li_class = '';
                echo "<li " . $li_class . ">";
                echo "<a href='" . $itemlink . "'>" . $detail[$key]['name'] . "</a>";
                if ($this->check_child($item)) {
                    echo "<ul class='dropdown-menu'>";
                    $this->builder_v($item['children'], $detail);
                    echo "</ul>";
                }
                echo "</li>";
            }
        }
    }
    private function builder_accordion($data,$detail) {
        if (!empty($data)) {
            foreach ($data as $item) {
                $key = $this->choose_item($detail, $item['id']);
                $itemlink = $this->url_builder($detail[$key]['type'], $detail[$key]['call']);
                if ($this->check_child($item)){
                    $li_class = "class='treeview'";
                    $i        = "<i class='fa fa-angle-left'></i>";
                }
                else{
                    $li_class = '';
                    $i          =   '';
                }
                echo "<li " . $li_class . ">";
                echo "<a href='$itemlink' title='{$detail[$key]['name']}'>{$detail[$key]['name']}". $i ."</a>";
                if ($this->check_child($item)) {
                    echo "<ul class='treeview-menu'>";
                    $this->builder_accordion($item['children'], $detail);
                    echo "</ul>";
                }
                echo "</li>";
            }
        }
    }
    private function builder($data,$detail) {
        foreach ($data as $item){
            $key    =   $this->choose_item($detail, $item['id']);
            if($this->check_child($item)){
                $a_class    =   "class='dropdown-toggle hover-dropdown' data-toggle='dropdown'";
                $li_class   =   "dropdown";
                $i          =   "<i class='fa fa-angle-down'></i>";
            }
            else {
                $a_class    =   "";
                $li_class   =   "";
                $i          =   "";
            }
            $curentlink     =   RELATIVE_PATH."/".$_GET['pf_page_url'];
            $itemlink       =   $this->url_builder($detail[$key]['type'], $detail[$key]['call']);
            if(isset($curentlink) && $curentlink==$itemlink){
                $li_class.=" active";
            }
            echo "<li class='".$li_class."'>";
            echo "<a href='".$itemlink."' ".$a_class."'>".$detail[$key]['name'].$i."</a>";
            if($this->check_child($item)){
                echo "<ul class='dropdown-menu'>";
                $this->builder($item['children'], $detail);
                echo "</ul>";
            }
            echo "</li>";
        }
    }
    public function builder_top($data,$detail) { 
        if (!empty($data)) {
            foreach ($data as $item) {
                $key = $this->choose_item($detail, $item['id']);
                $itemlink = $this->url_builder($detail[$key]['type'], $detail[$key]['call']);
                $active = "";
                $post_page     = get_configuration('page_lists', 'pf_post');
                if( public_url('',true)==$itemlink.'/'){
                    $active = "active-color";
                }else if(public_url($post_page,false)==$itemlink){
                    $page_detail     = get_configuration('page_detail', 'pf_post');
                    if($page_detail == $_GET['pf_page_url']){
                        $active = "active-color";
                    }
                }
                if($detail[$key]['icon']!=''){
                    switch ($detail[$key]['icontype']) {
                        case 'css':
                            $name   =   "<i class='".$detail[$key]['icon']."'></i> ".$detail[$key]['name'];
                            break;
                        case 'img':
                            $name   =   "<img src='".public_base_url().$detail[$key]['icon']."'/> ".$detail[$key]['name'];
                    }
                }
                else
                    $name   =   $detail[$key]['name'];
                if($detail[$key]['desc']!='')
                    $desc   =   "<p class='menu-desc'>".$detail[$key]['desc']."</p>";
                else
                    $desc   =   "";
                if ($this->check_child($item)){

                    $li_class = "class='dropdown $active'";
                    $a_class  = "class='dropdown-toggle hover-dropdown' data-toggle='dropdown' data-close-others='false'";
                    $itemlink ="#";
                    $i        = "<i class='caret'></i>";
                }
                else{
                    $li_class = "class='$active'";
                    $a_class    = '';
                    $i          =   '';
                }
                echo "<li " . $li_class . ">";
                echo "<a href='$itemlink".$detail[$key]['options']."' $a_class >".$name ."  ". $i ." $desc</a>";
                if ($this->check_child($item)) {
                    echo "<ul class='dropdown-menu sub'>";
                    $this->builder_top($item['children'], $detail);
                    echo "</ul>";
                }
                echo "</li>";
            }
        }
    }
    private function builder_footer($data,$detail) { 
        if (!empty($data)) {
            foreach ($data as $item) {
                $key = $this->choose_item($detail, $item['id']);
                $itemlink = $this->url_builder($detail[$key]['type'], $detail[$key]['call']);
                echo "<li>";
                echo "<a href='" . $itemlink . "'>" . $detail[$key]['name'] . "</a>";
                if ($this->check_child($item)) {
                    echo "<ul class='widget_submenu'>";
                    $this->builder_footer($item['children'], $detail);
                    echo "</ul>";
                }
                echo "</li>";
            }
        }
    }
    public function list_menu() {
        $all    =   get_option('menu');
        foreach ($all as $menu){
            $list[$menu['id']]  =   $menu['name'];
        }
        return $list;
    }
    
    public function show_menu($id, $type = '') {
        $data = $this->pick_menu($id);
        if (!empty($data[0]))
            $data[0] = $this->filter_menu($data[0], $data[1]);
        if (!empty($data)) {
            if ($type == 'v')
                $this->builder_v($data[0], $data[1]);
            elseif ($type == 'top')
                $this->builder_top($data[0], $data[1]);
            elseif ($type == 'footer') {
                $this->builder_footer($data[0], $data[1]);
            } elseif($type == 'accordion'){
                $this->builder_accordion($data[0],$data[1]);
            }else{
                $this->builder($data[0], $data[1]);
            }

        }
    }

}
